﻿using System.Collections.Generic;
using System.Windows.Controls;
using System.Windows.Media;

namespace Microscopic_Traffic_Simulator.Views.MainWindowView
{
    /// <summary>
    /// Class representing topology canvas.
    /// </summary>
    class TopologyCanvas : Canvas
    {
        /// <summary>
        /// List of visuals of canvas. One visual is for geometric topology and another visual
        /// for simulation (cars).
        /// </summary>
        private List<DrawingVisual> visuals = new List<DrawingVisual>();

        /// <summary>
        /// Number of visuals in visual list.
        /// </summary>
        protected override int VisualChildrenCount
        {
            get
            {
                return visuals.Count;
            }
        }

        /// <summary>
        /// Get visual from visuals list.
        /// </summary>
        /// <param name="index">Index of visual in visuals list.</param>
        /// <returns>Visual from visuals list.</returns>
        protected override Visual GetVisualChild(int index)
        {
            return visuals[index];
        }

        /// <summary>
        /// Create and add new visual to list of visuals and also to visual childs.
        /// </summary>
        /// <returns>Created visual for drawing.</returns>
        internal DrawingVisual CreateNewVisual()
        {
            DrawingVisual newVisual = new DrawingVisual();
            visuals.Add(newVisual);
            AddVisualChild(newVisual);
            return newVisual;
        }
    }
}
